package gov.va.genisis2Test.controller;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.exceptions.ErrorResponse;
import gov.va.genisis2.exceptions.Genisis2RestException;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class Genisis2ControllerTest.
 *
 * @param <performTableCopyTransfer>
 *            the generic type
 * @author1 Janet Lopez
 * 
 *          The Class Genisis2ControllerTest.
 * 
 *          Description: In this Genisis2ControllerTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class Genisis2ControllerTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(Genisis2ControllerTest.class);

	/**
	 * This method is used to testGenisis2ControllerAllRequests.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testAllRequests() throws Exception {
		logger.info("**********Junit Get all requests**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getAllRequests()).thenReturn(wrapper);
		getMockMvc().perform(
				get("/services/requests").contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByID() throws Exception {
		logger.info("**********Junit Get Request by ID**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTrackingByID(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}", idL.toString()).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerCopyTableDomains.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testCopyTableDomains() throws Exception {
		logger.info("**********Junit Get Copy Table Domains**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getCopyTableDomains()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/copytable/domains").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetDataSources.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetDataSources() throws Exception {
		logger.info("**********Junit Get Data Sources**********");

		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestDataSources()).thenReturn(wrapper);
		getMockMvc().perform(
				get("/services/datasources").contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUserDetailsByEmail.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserDetailsByEmail() throws Exception {
		logger.info("**********Junit Get Login Details By Email**********");
		String email = "emailid@gmail.com";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getUserDetailsByEmail(email)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/users/{email}/email", email.toString())
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUsersDetailsById.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUsersDetailsById() throws Exception {
		logger.info("**********Junit Get Login Details By Id**********");
		int id = 1;
		ResponseWrapper wrapper = new ResponseWrapper();
		getMockMvc().perform(get("/services/users/{id}", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetUserRole.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetUserRole() throws Exception {
		logger.info("**********Junit Get User Role**********");
		int id = 1;
		getMockMvc().perform(get("/services/users/role/{uid}", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestsByUser.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestsByUser() throws Exception {
		logger.info("**********Junit Get Requests By User**********");
		String uid = "testresearcher";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsByUID(uid)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{uid}/createdBy", uid).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByDataManager.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByDataManager() throws Exception {
		logger.info("**********Junit Get Requests By Data Manager**********");
		String id = "tesdatatmanager";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsByDataManagers(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/dataManager", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}
	
	/**
	 * This method is used to testGenisis2ControllerGetRequestsDataSourceManagers.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestsDataSourceManagers() throws Exception {
		logger.info("**********Junit Get Requests for Data Source Managers**********");
		String id = "tesdatasourcemanagers";
		ResponseWrapper wrapper = new ResponseWrapper();
		when(getMockBusinessService().getRequestsDataSourceManagers(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/dataSourceManager", id).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());
	}

	/**
	 * This method is used to
	 * testGenisis2ControllerGetRequestStudyApprovalsByIDUID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestStudyApprovalsByIDUID() throws Exception {
		logger.info("**********Junit Get Study Approvals by UID**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getAllRequestsByStudyApproval(id)).thenReturn(wrapper);
		getMockMvc()
				.perform(get("/services/requests/{studyApprovalId}/studyApproval", idL.toString())
						.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetAllStudyApproval.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetAllStudyApproval() throws Exception {
		// set up studyApproval model in setup using hibernate template
		logger.info("**********Junit Get All Request By Study Approval**********");

		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovals()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetAllStudyApprovalsByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetAllStudyApprovalsByID() throws Exception {
		logger.info("**********Junit Get All Study Approvals**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovalsByID(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals/{id}", idL.toString())
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetStudyApprovalsByIDUID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetStudyApprovalsByIDUID() throws Exception {
		logger.info("**********Junit Get Study Approvals by UID**********");
		String uid = "testmanager";
		String user = "testmanager";
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getStudyApprovalsByUID(uid)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/studyApprovals/{uid}/{user}", uid, user)
				.contentType(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestTrackingByID.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestTrackingByID() throws Exception {
		logger.info("**********Junit Get Request Tracking by ID**********");
		int id = 1;
		Long idL = 1L;
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTrackingByID(id)).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requests/{id}/log", idL.toString()).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestTypes.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestTypes() throws Exception {
		logger.info("**********Junit Get Request Types**********");
		ResponseWrapper wrapper = new ResponseWrapper();

		when(getMockBusinessService().getRequestTypes()).thenReturn(wrapper);
		getMockMvc().perform(get("/services/requestTypes").contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerGetRequestByStatus.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testGetRequestByStatus() throws Exception {
		logger.info("**********Junit Get All Request By Status**********");
		String status1 = CommonEnum.NO_RECORD_FOUND.getText();
		ResponseWrapper wrapper = new ResponseWrapper();

		getMockMvc().perform(get("/services/requests/{status}/status", status1).contentType(MediaType.APPLICATION_JSON)
				.accept(MediaType.APPLICATION_JSON)).andExpect(status().isOk());

	}

	/**
	 * This method is used to testGenisis2ControllerPutConfirmData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutConfirmData() throws Exception {
		logger.info("**********Junit put confirm**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().acceptData(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put confirm  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutAcceptData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutAcceptData() throws Exception {
		logger.info("**********Junit put accept**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().fulfillRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put accept  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutRejectData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutRejectData() throws Exception {
		logger.info("**********Junit put reject**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().rejectData(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put reject  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutDenyData.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutDenyData() throws Exception {
		logger.info("**********Junit put deny**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().unFulfillRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put deny  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutReturn.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutReturn() throws Exception {
		logger.info("**********Junit put return**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().returnRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put return  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutUpdate.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutUpdate() throws Exception {
		logger.info("**********Junit put update request**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().updateRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put update request  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutSubmit.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestPutSubmit() throws Exception {
		logger.info("**********Junit put submit  **********  ");

		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().submitRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put submit  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutDeny.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestPutDeny() throws Exception {
		logger.info("**********Junit put deny  **********  ");

		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().denyRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put deny  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutSent.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestPutSent() throws Exception {
		logger.info("**********Junit put sent  **********  ");

		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().sentRequest(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put sent  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutResultsDelivered.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutResultsDelivered() throws Exception {
		logger.info("**********Junit put Results Delivered**********");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().requestDeliver(id, request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put Results Delivered  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerPutStudyApproval_1.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutStudyApproval_1() throws Exception {
		logger.info("**********Junit put StudyApproval**********");
		// id is > 0
		int id = 3;

		StudyApproval studyApproval = Helper.getStudyApproval();

		ResponseEntity ent = getGenisis2Controller().updateStudyApproval(id, studyApproval);

		Assert.assertNotNull(ent.getStatusCode());
		logger.info("**********End of Junit put StudyApproval**********");
	}

	/**
	 * This method is used to testGenisis2ControllerPutStudyApproval_2.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void testPutStudyApproval_2() throws Exception {
		logger.info("**********Junit put StudyApproval**********");
		// id is 0
		int id = 0;

		StudyApproval studyApproval = Helper.getStudyApproval();

		ResponseEntity ent = getGenisis2Controller().updateStudyApproval(id, studyApproval);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end test for Junit put StudyApproval  **********  ");

	}

	/**
	 * This method is used to testGenisis2ControllerCreateComment.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void createComment() throws Exception {
		logger.info("**********Junit POST TEST for Create Comment  **********  ");
		CommentHistory commentHistory = new CommentHistory();
		commentHistory.setRequestId(1);
		commentHistory.setComments("testing");
		commentHistory.setStatus("Submitted");
		commentHistory.setCreatedBy("datamanager1");
		ResponseEntity ent = getGenisis2Controller().createCommentHistory(commentHistory);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("**********End of Junit POST TEST for Create Comment **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to testGenisis2ControllerCreateRequest.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void createRequest() throws Exception {
		logger.info("**********Junit POST TEST for Create Request  **********  ");
		int id = 1;

		Request request1 = getMockRequestService().getRequestsById(id);

		ResponseEntity ent = getGenisis2Controller().createRequest(request1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("**********End of Junit POST TEST for Create Request *********** " + ent.getStatusCode());

	}

	/**
	 * This method is used to
	 * testGenisis2ControllerPerformTableCopyTransferTest.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void performTableCopyTransferTest() throws Exception {
		logger.info("**********Junit POST TEST for perform Table Copy Transfer  **********  ");
		int id = 1;
		CopyTableSource copyTableSource1 = new CopyTableSource();
		copyTableSource1.setTableName("Table1");

		ResponseEntity ent = getGenisis2Controller().performTableCopyTransfer(id, copyTableSource1);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("**********End of Junit POST TEST for Table Copy Transfer **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to testGenisis2ControllerCreateStudyApproval.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void createStudyApproval() throws Exception {
		logger.info("**********Junit POST TEST for create Study Approval  **********  ");
		int id = 1;

		StudyApproval studyApproval = getMockStudyApprovalService().getStudyApprovalsByID(id);

		ResponseEntity ent = getGenisis2Controller().createStudyApproval(studyApproval);

		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end of Junit POST TEST for Study Approval  **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to TestException.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestException() throws Exception {
		logger.info("**********Junit POST TEST for Exception  **********  ");

		Genisis2RestException ex = new Genisis2RestException("errorMessageTestOne");

		ResponseEntity<ErrorResponse> ent = getGenisis2Controller().exceptionHandler(ex);
		Assert.assertNotNull(ent.getStatusCode());

		logger.info("********** end of Junit POST TEST for Exception  **********  " + ent.getStatusCode());

	}

	/**
	 * This method is used to TestGetBusiness.
	 * 
	 * @exception Exception
	 *                The exception.
	 */
	@Test
	public void TestGetBusiness() throws Exception {
		logger.info("**********Junit for bo*********");

		BusinessService bo = getGenisis2Controller().getBusinessService();
		Assert.assertNotNull(bo);

		logger.info("********** end of Junit for bo**********");

	}

}
